using System;

class Program
{
    static int HighestPowerOfTwoLessThanN(int n)
    {
        int power = 1;
        while (power * 2 <= n)
        {
            power *= 2;
        }
        return power;
    }

    static int[] GetNewRanking(int[] currentRanking)
    {
        int K = currentRanking.Length;
        int[] winners = new int[K / 2];

        for (int i = 0; i < K / 2; i++)
        {
            int winner = Math.Max(currentRanking[2 * i], currentRanking[2 * i + 1]);
            winners[i] = winner;
        }

        Array.Sort(winners);
        int[] newRanking = new int[K / 2];
        for (int i = 0; i < K / 2; i++)
        {
            newRanking[i] = i + 1;
        }

        return newRanking;
    }

    static int MaxRounds(int N, int M, int J)
    {
        int rounds = 0;
        int[] ranking = new int[N];
        for (int i = 0; i < N; i++)
        {
            ranking[i] = i + 1;
        }

        while (true)
        {
            rounds++;
            ranking = GetNewRanking(ranking);

            if (Array.IndexOf(ranking, M) < HighestPowerOfTwoLessThanN(N))
            {
                return rounds;
            }

            if (J == 0)
            {
                break;
            }

            J--;
            int idx1, idx2;
            do
            {
                idx1 = new Random().Next(0, N);
                idx2 = new Random().Next(0, N);
            } while (ranking[idx1] == M || ranking[idx2] == M || idx1 == idx2);

            int temp = ranking[idx1];
            ranking[idx1] = ranking[idx2];
            ranking[idx2] = temp;
        }

        return rounds;
    }

    static void Main()
    {
        int N = 8; // Broj ucesnika u turniru, mora biti stepen broja 2
        int Q = 2; // Broj opcija

        int[] Mi = { 8, 7 }; // Mi: Mišljenik, odnosno igrac kojem pomažemo da ostvari bolji rezultat
        int[] Ji = { 2, 1 }; // Ji: Broj zamena koje smo spremni da izvršimo za svaku opciju

        for (int i = 0; i < Q; i++)
        {
            int maxRounds = MaxRounds(N, Mi[i], Ji[i]);
            Console.WriteLine($"Opcija {i + 1}: Najveci broj krugova za mišljenika {Mi[i]} je {maxRounds}");
        }
    }
}